<?php
/**
 * VFM - veno file manager: /admin-panel/ajax/clear-share.php
 *
 * Clear /thumbnails/ folder
 *
 * PHP version >= 5.3
 *
 * @category  PHP
 * @package   VenoFileManager
 * @author    Nicola Franchini <support@veno.it>
 * @copyright 2013 Nicola Franchini
 * @license   Exclusively sold on CodeCanyon
 * @link      http://filemanager.veno.it/
 */
if (!isset($_SERVER['HTTP_X_REQUESTED_WITH']) 
    || (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest')
) {
    exit;
}
require_once dirname(dirname(__DIR__)).'/class/class.setup.php';
require_once dirname(dirname(__DIR__)).'/class/class.utils.php';
require_once dirname(dirname(__DIR__)).'/class/class.gatekeeper.php';
require_once dirname(dirname(__DIR__)).'/class/class.downloader.php';

$setUp = new SetUp();
$gateKeeper = new GateKeeper();
$downloader = new Downloader();

if (!$gateKeeper->isSuperAdmin()) {
    die('Permission Denied');
}
$get_lifetime = filter_input(INPUT_POST, 'lifetime', FILTER_VALIDATE_INT);
$lifetime = $get_lifetime ? $get_lifetime : $setUp->getConfig('lifetime');

// remove old files
$shortens = glob(dirname(dirname(__DIR__))."/_content/share/*.json");

foreach ($shortens as $shorten) {
    if (is_file($shorten)) {
        $filetime = filemtime($shorten);

        if (!$downloader->checkTime($filetime, $lifetime)) {
            unlink($shorten);
        }
    }
}
echo 'success';
exit;
