<?php
/**
 * VFM - veno file manager: include/activate.php
 * Activate new pending user
 *
 * PHP version >= 5.3
 *
 * @category  PHP
 * @package   VenoFileManager
 * @author    Nicola Franchini <support@veno.it>
 * @copyright 2013 Nicola Franchini
 * @license   Exclusively sold on CodeCanyon
 * @link      http://filemanager.veno.it/
 */
if (!defined('VFM_APP')) {
    return;
}

$regactive = filter_input(INPUT_GET, "act", FILTER_SANITIZE_SPECIAL_CHARS);
$enable = filter_input(INPUT_GET, "enable", FILTER_SANITIZE_SPECIAL_CHARS);

if ($enable) {
    // Enable new user by admin.
    $username = $updater->searchUser('enable_key', $enable);
    $updatedata = array(
        'disabled' => false,
        'enable_key' => false
    );

    if ($username) {
        $users = $updater->updateUserData($username, $updatedata);
        $updater->updateUserFile('enable', false, $users);

        Utils::setSuccess($setUp->getString("account_activated").': <strong>'.$username.'</strong>');

        $to = $updater->searchUser('name', $username, 'email');
        $subject = $setUp->getString("account_activated");
        $content = $setUp->getString("your_account_has_been_approved").' <br>'.$setUp->getString("username").': <strong>'.$username.'<strong>';
        $content_txt = $setUp->getString("your_account_has_been_approved").'\n'.$setUp->getString("username").': '.$username;

        Logger::sendMail(false, $to, $subject, $content, $content_txt);
    } else {
        Utils::setError($setUp->getString("nothing_found"));   
    }
}

if ($regactive && $setUp->getConfig("registration_enable") == true) :
    // Activate new account via email.
    $newusers = $gateKeeper->getUsersNew();

    if ($newusers) {
        $newuser = $updater->findUserKey($regactive);

        if ($newuser !== false) {
            $_USERS = $gateKeeper->getUsers();
            $users = $_USERS;

            $registration_lifetime = $setUp->getConfig('registration_lifetime', '-1 day');
            $lifetime = date("Y-m-d-H-i-s", strtotime($registration_lifetime));

            $newusers = $updater->removeOldReg($newusers, 'date', $lifetime);

            $username = $newuser['name'];
            $usermail = $newuser['email'];

            // Send request to admin
            $request_approvation = $setUp->getConfig('request_approvation');

            if (strlen($request_approvation) >= 5) {

                $enable_key = md5(Utils::randomString().$username);

                $newuser['disabled'] = true;
                $newuser['enable_key'] = $enable_key;
            }

            if ($updater->findUser($username) === false && $updater->findUser($usermail, true) === false) {
                array_push($users, $newuser);
                $updater->updateUserFile('new', false, $users);
            } else {
                Utils::setError('<strong>'.$username.'</strong> '.$setUp->getString('file_exists'));
            }

            // Clean current confirmed user.
            $newusers = $updater->removeUserFromValue($newusers, 'name', $username);
            $newusers = $updater->removeUserFromValue($newusers, 'email', $usermail);

            if ($updater->updateRegistrationFile($newusers)) {

                if (strlen($request_approvation) >= 5) {

                    $appurl = $setUp->getConfig('script_url');
                    $enablelink = $appurl."?enable=".$enable_key;

                    $subject = $setUp->getString("activate_account");
                    $content = $setUp->getString("new_user_registered").'<br>'.$enablelink.'<br><br>';
                    $content .= $setUp->getString("username").': <strong>'.$username.'</strong><br>';
                    $content .= $setUp->getString("email").': <strong>'.$usermail.'</strong><br>';
                    $text_content = $setUp->getString("new_user_registered").'\n'.$enablelink.'\n\n';
                    $text_content .= $setUp->getString("username").': '.$username.'\n';
                    $text_content .= $setUp->getString("email").': '.$usermail.'\n';

                    $loggermail = Logger::sendMail(false, $request_approvation, $subject, $content, $text_content);
                    if ($loggermail !== 'success') {
                        Utils::setError($loggermail);
                    }

                    Utils::setWarning($setUp->getString("pending_activation"));

                } else {
                    Utils::setSuccess($setUp->getString("registration_completed"));
                }

                // Send new registration log to administrator.
                if (strlen($setUp->getConfig('upload_email')) > 5 && $setUp->getConfig('notify_registration')) {
                    $send_data = json_encode($setUp->getString('user')." : ".$username."\n".$setUp->getString('email')." : ".$usermail."\n");
                    $loggermail = Logger::emailNotification(false, 'newuser', $send_data);
                    if ($loggermail !== 'success') {
                        Utils::setError($loggermail);
                    }
                }

            } else {
                Utils::setWarning('Failed updating registration file');
            }
        } else {
            Utils::setError($setUp->getString('link_expired'));
        }
    }
endif;
